import { Camera, Mail, Phone, MapPin, Instagram, Facebook } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Camera size={32} strokeWidth={2.5} className="footer-logo-icon" />
              <h2 className="footer-logo-text">PhotoStudio</h2>
            </div>
            <p className="footer-description">
              Профессиональные фотосессии для создания незабываемых моментов. 
              Мы превращаем ваши воспоминания в произведения искусства.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link" aria-label="Instagram">
                <Instagram size={24} strokeWidth={2} />
              </a>
              <a href="#" className="social-link" aria-label="Facebook">
                <Facebook size={24} strokeWidth={2} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Phone size={20} strokeWidth={2} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={20} strokeWidth={2} />
                <a href="mailto:info@photostudio.ru">info@photostudio.ru</a>
              </li>
              <li>
                <MapPin size={20} strokeWidth={2} />
                <span>г. Москва, ул. Фотографическая, д. 15</span>
              </li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Услуги</h3>
            <ul className="footer-links">
              <li><a href="#">Портретная съёмка</a></li>
              <li><a href="#">Семейная фотосессия</a></li>
              <li><a href="#">Love Story</a></li>
              <li><a href="#">Брендовая съёмка</a></li>
              <li><a href="#">Свадебная фотография</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Режим работы</h3>
            <ul className="footer-links">
              <li>Пн-Пт: 10:00 - 20:00</li>
              <li>Сб-Вс: 11:00 - 19:00</li>
            </ul>
            <div className="footer-cta">
              <p>Запишитесь на консультацию</p>
              <a href="/book" className="footer-cta-button">Записаться</a>
            </div>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 PhotoStudio. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

